<?php
$path = __DIR__ . '/blacklist.json';

// Читаем текущие данные
$current = file_exists($path) ? json_decode(file_get_contents($path), true) : [];

if (!is_array($current)) {
    $current = [];
}

// Новая запись из запроса
$data = json_decode(file_get_contents("php://input"), true);

if (is_array($data)) {
    foreach ($data as $hwid => $entry) {
        $current[$hwid] = $entry; // обновить или создать
    }

    file_put_contents($path, json_encode($current, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(["status" => "success"]);
} else {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Invalid JSON"]);
}
?>
